/*** CONFIDENTIAL ***/
/* Copyright (C) 2011 2012 2013, Panasonic Corporation */
#ifndef	_IPR_BRIDGE_DATA_H_
#define	_IPR_BRIDGE_DATA_H_

#include <linux/iosc/ipr_api_data.h>

#define IPR_L_DEVID_MAX_NUM (IPR_MINOR_NUM - 1)
#define IPR_L_MAX_TH_NUM    10
#define IPR_MAX_FD_NAME     256

typedef int IPR_FIX16;

typedef enum {
	IPR_L_WARN0 = 0x9D00,	
	IPR_L_WARN1,		
	IPR_L_FATAL,		
} ipr_ERRMSG_t;

typedef enum {
  IPR_L_ATVD_IN,     
  IPR_L_EXT_DEV1_IN,
  IPR_L_EXT_DEV2_IN,
  IPR_L_EXIV_IN,
} ipr_input_dev_t;

typedef enum {
	IPR_L_NONE,
	IPR_L_MAIN,
	IPR_L_SUB,
	IPR_L_MAIN_SUB,
} ipr_main_sub_t;

typedef enum {
	IPR_L_DEPTH_8 = 8,		
	IPR_L_DEPTH_10 = 10,		
} ipr_depth_t;

typedef enum {
	IPR_L_OFF,
	IPR_L_ON,
} ipr_onoff_t;

typedef enum {
	IPR_L_LEVEL_OFF,
	IPR_L_LEVEL_1,
	IPR_L_LEVEL_2,
	IPR_L_LEVEL_3,
	IPR_L_LEVEL_4,
	IPR_L_LEVEL_5,
	IPR_L_LEVEL_6,
	IPR_L_LEVEL_7
} ipr_level_t;

typedef enum {
	IPR_L_PORT_A,		
	IPR_L_PORT_B,		
	IPR_L_PORT_C,		
	IPR_L_PORT_D,		
	IPR_L_PORT_NONE,	
} ipr_port_t;

typedef enum {
	IPR_L_INTERLACE,		
	IPR_L_PROGRESSIVE,		
} ipr_ip_t;

typedef enum {
	IPR_L_COLOR_YUV,	
	IPR_L_COLOR_RGB,	
} ipr_color_t;

typedef enum {
	IPR_L_8BIT=8,		
	IPR_L_10BIT=10,		
	IPR_L_12BIT=12,		
	IPR_L_16BIT=16,		
	IPR_L_18BIT=18,		
	IPR_L_20BIT=20,		
	IPR_L_24BIT=24,		
	IPR_L_30BIT=30,		
} ipr_bit_t;

typedef enum {
	IPR_L_MANUAL = 0,		
	IPR_L_AUTO = 1,		
} ipr_auto_t;

typedef enum {
	IPR_L_POSITIVE,	
	IPR_L_NEGATIVE,	
} ipr_polarity_t;

typedef enum {
  IPR_L_PULLDOWN_detect_win,
  IPR_L_PULLDOWN_telop_win,
} ipr_pulldown_win_t;

typedef struct {
  IPR_FIX16 hlen_ratio;
  IPR_FIX16 vlen_ratio;
  unsigned char frame_div_thresh;
  unsigned char det_thresh;
} ipr_sidepanel_t;

typedef struct {
  ipr_onoff_t spdet_onoff;
  unsigned char move_value;
  unsigned short max_y;
} ipr_get_spdet_t;

typedef enum {
  IPR_L_DMA_OUT_PORT,
  IPR_L_DMA_ALL_PORT,
} ipr_dma_port_t;

#define IPR_PC_UNKNOWN          0       
typedef struct {
  unsigned short        width;          
  unsigned short        height;         
  unsigned short        all_h;          
  unsigned short        all_v;          
  float                 h_freq;         
  float                 v_freq;         
  float                 pix_freq;       
  unsigned short        h_blank;        
  unsigned short        v_blank;        
} ipr_pc_format_t;

typedef enum {
	IPR_L_TRID_FORM_2D,              
	IPR_L_TRID_FORM_SBS_HALF,        
	IPR_L_TRID_FORM_FP,              
	IPR_L_TRID_FORM_FA,              
	IPR_L_TRID_FORM_FS,              
	IPR_L_TRID_FORM_TB,              
	IPR_L_TRID_FORM_LA,              

	IPR_L_TRID_FORM_4K2K,            
	IPR_L_TRID_FORM_SBS_FULL,        
	IPR_L_TRID_FORM_FP_FA,           
	IPR_L_TRID_FORM_FP_720P,         
	IPR_L_TRID_FORM_CB,              
	IPR_L_TRID_FORM_2D3D,            
	IPR_L_TRID_FORM_FHD,             
	IPR_L_TRID_FORM_FHD_LR,          
	IPR_L_TRID_FORM_TB_LR,           
	IPR_L_TRID_FORM_FP_LR,           
	IPR_L_TRID_FORM_FS_LR,           
	IPR_L_TRID_FORM_2K2K_LR,         
	IPR_L_TRID_FORM_FHD_SP,          
	IPR_L_TRID_FORM_FRC_FS_LR,       
	IPR_L_TRID_FORM_FRC_LA_LR,       
	IPR_L_TRID_FORM_FRC_Dual_LR,     
	IPR_L_TRID_FORM_FRC_2D_60HZ,     
	IPR_L_TRID_FORM_FRC_2D_120HZ,    
	IPR_L_TRID_FORM_FRC_LA_LR_60HZ,  
	IPR_L_TRID_FORM_TP = IPR_L_TRID_FORM_TB,
} ipr_3D_form_t;

typedef enum{
	IPR_L_TRID_LR_NORMAL,
	IPR_L_TRID_LR_FIX_L,
	IPR_L_TRID_LR_FIX_R,
	IPR_L_TRID_LR_SWAP,
}ipr_trid_lr_sel_t;

typedef enum{
  IPR_L_SBS_QCX_OFF,
  IPR_L_SBS_QCX_ODD_ODD,
  IPR_L_SBS_QCX_ODD_EVEN,
  IPR_L_SBS_QCX_EVEN_ODD,
  IPR_L_SBS_QCX_EVEN_EVEN,
} ipr_sbs_qcx_t;

typedef struct {
  ipr_level_t motion_level;
  ipr_level_t noise_level;
  ipr_level_t edge_level;
  unsigned char final_level;
} ipr_DNR_level_t;

typedef struct {
	unsigned long	offset_x;
	unsigned long	offset_y;
	IPR_FIX16			all_h;
	IPR_FIX16			all_v;
	IPR_FIX16			act_h;
	IPR_FIX16			act_v;
	IPR_FIX16			freq;
	ipr_ip_t		ip;
	ipr_color_t	color_form;
	ipr_bit_t		bitnum;
	ipr_polarity_t	polarity_h;
	ipr_polarity_t	polarity_v;
	ipr_onoff_t		twice_wr;
} ipr_form_t;

typedef struct {
	ipr_port_t			port;
	ipr_input_dev_t		device;
	ipr_form_t			format;
	ipr_3D_form_t		TriD_format;
	ipr_sbs_qcx_t		sbs_quincunx;
} ipr_input_format_t;

typedef struct{

	ipr_trid_lr_sel_t lr_sel;
	int convergence;
	int depth_control;
	int tridconv_convergence;
	int tridconv_intensity;
}ipr_trid_param_t;

typedef struct {
	unsigned long	display_x;
	unsigned long	display_y;
	unsigned long	display_w;
	unsigned long	display_h;
	long		order;
} ipr_layout_t;

typedef struct {
	IPR_FIX16	ovs_posi_x;
	IPR_FIX16	ovs_posi_y;
	IPR_FIX16	ovs_rate_h;
	IPR_FIX16	ovs_rate_v;
} ipr_OVS_param_t;

typedef struct{
	ipr_form_t		format;
	ipr_onoff_t 	rev_scan;
	ipr_3D_form_t	TriD_format;
} ipr_output_format_t;

typedef struct {
	ipr_onoff_t		on_off;
	unsigned long	hold_width;
	float			hold_exp_ratio;
} ipr_just_param_t;

typedef struct {
	ipr_ER_t	status;
} ipr_just_status_t;

typedef struct {
	ipr_onoff_t		send_f;
	unsigned long	thresh_num;
	unsigned long	*thresh;
	unsigned long	time;
} ipr_det_condition_t;

typedef struct {
	ipr_det_condition_t	all_width;
	ipr_det_condition_t	all_line;
	ipr_det_condition_t	vfreq;
	ipr_det_condition_t	hfreq;
} ipr_siginfo_condition_t;

typedef struct {
	unsigned long	all_width;
	unsigned long	all_line;
	IPR_FIX16	vfreq;
	IPR_FIX16	hfreq;
} ipr_siginfo_t;

typedef enum {
	IPR_L_SIGCHG_ALL_WIDTH 	= 0x00000001,
	IPR_L_SIGCHG_ALL_LINE 	= 0x00000002,
	IPR_L_SIGCHG_HFREQ		= 0x00000004,
	IPR_L_SIGCHG_VFREQ		= 0x00000008,
} ipr_siginfo_type_t;

typedef enum {
	IPR_L_AT_MNIP,		
	IPR_L_AT_MVR,		
	IPR_L_AT_SNIP,		
	IPR_L_AT_SVR,		
} ipr_pix_place_t;

typedef struct {
	struct {			
		ipr_color_t		color;		
		unsigned short		depth;	
	}		format;
	struct {			
		unsigned short		y;		
		unsigned short		cb;		
		unsigned short		cr;		
	}		ycbcr;
	struct {			
		unsigned short		r;	
		unsigned short		g;	
		unsigned short		b;	
	}		rgb;
	struct {			
		ipr_pix_place_t		place;	
		unsigned short		x;	
		unsigned short		y;	
	}		location;
} ipr_pix_t;


typedef struct {
	union {					
		char			array[8];	
		struct {				
			char			fil00y;		
			char			fil01y;		
			char			fil02y;		
			char			fil03y;		
			char			fil04y;		
			char			fil05y;		
			char			fil06y;		
			char			fil07y;		
		}			factor;
	}			y_factor;
	union {					
		char			array[8];	
		struct {				
			char			fil00c;		
			char			fil01c;		
			char			fil02c;		
			char			fil03c;		
			char			fil04c;		
			char			fil05c;		
			char			fil06c;		
			char			fil07c;		
		}			factor;
	}			c_factor;
} ipr_filter_t;

typedef enum {
	IPR_L_1080P,	
	IPR_L_1080I,	
	IPR_L_720P,	
	IPR_L_PAL576I,	
	IPR_L_480P,	
	IPR_L_480I,	
} ipr_stream_format_t;

typedef struct {
	ipr_stream_format_t	input_format;
	enum{
		IPR_L_WINDOW_TYPE1,
		IPR_L_WINDOW_TYPE2,
	} window_type;
	unsigned short	start_line;
	unsigned short	end_line;
	unsigned char	h_offset;
} ipr_detection_window_t;

typedef struct {
	unsigned char	thresh_l;
	unsigned char	thresh_h;
	unsigned char	color_thresh;
} ipr_class_thresh_t;

typedef struct {
	unsigned char	thresh1;
	unsigned char	thresh2;
	unsigned char	thresh3;
	unsigned char	thresh4;
} ipr_histgram_thresh_t;

typedef struct {
	struct{
		unsigned char	line_brightness_thresh;
		unsigned char	APL_thresh;
	} brightness_thresh;
	struct{
		unsigned short	max_picture_start_line;
		unsigned short	min_picture_end_line;
	}line_error;
} ipr_selfwide_err_thresh_t;


typedef struct {
	unsigned char	edge_num;
	union{
		unsigned long	whole;
		struct {
			unsigned long	apl_error		: 	1;
			unsigned long	odd_line_error	:	1;
		} flag;
	} error;
} ipr_selfwide_reliability_t;


typedef struct {
	unsigned short	picture_start;
	unsigned short	picture_end;
	unsigned short	subtitle_start;
	unsigned short	subtitle_end;
	ipr_selfwide_reliability_t	reliability;
} ipr_selfwide_param_t;

typedef struct {
  IPR_FIX16 hstart_ratio;
  IPR_FIX16 vstart_ratio;
  IPR_FIX16 hlen_ratio;
  IPR_FIX16 vlen_ratio;
} ipr_pulldown_win_size_t;

typedef struct {
	short	offset;
	unsigned short	gain;
} ipr_YUV_level_param_t;

typedef enum {
	IPR_L_GAIN_NORMAL,
	IPR_L_GAIN_DOUBLE,
} ipr_YUV_gain_mode_t;

typedef enum {
  IPR_L_PULLDOWN_OFF,
  IPR_L_PULLDOWN_2_3,
  IPR_L_PULLDOWN_2_2,
  IPR_L_PULLDOWN_2224,
  IPR_L_PULLDOWN_2332,
  IPR_L_PULLDOWN_55,
  IPR_L_PULLDOWN_64,
  IPR_L_PULLDOWN_87,
} ipr_pulldown_mode_t;

typedef struct {
	ipr_YUV_level_param_t	Y;
	ipr_YUV_level_param_t	U;
	ipr_YUV_level_param_t	V;
	ipr_YUV_gain_mode_t	Y_gain_mode;
	ipr_YUV_gain_mode_t	C_gain_mode;
} ipr_YUV_level_t;

typedef enum {
	IPR_L_CMETRY_OFF,			
	IPR_L_CMETRY_SD,			
	IPR_L_CMETRY_HD,			
} ipr_cmetry_t;



typedef struct {
  unsigned long y_gain;
  unsigned long y_block_gain_0;
  unsigned long y_block_gain_1;
  unsigned char y_2dnr_gain;
} ipr_YNR_strength_t;

typedef struct {
  unsigned long y_th0;
  unsigned long y_th1;
  unsigned long y_th2;
  unsigned long y_th3;
  unsigned long y_th4;
  unsigned long y_th5;
  unsigned long y_th6;
  unsigned long y_th7;
  unsigned long y_block_low_th;
  unsigned long y_block_high_th;
  unsigned long y_block_core;
} ipr_YNR_sensitivity_t;

typedef struct {
  unsigned long uv_gain;
  unsigned long uv_block_gain_0;
  unsigned long uv_block_gain_1;
} ipr_CNR_strength_t;

typedef struct {
  unsigned long uv_th0;
  unsigned long uv_th1;
  unsigned long uv_th2;
  unsigned long uv_th3;
  unsigned long uv_th4;
  unsigned long uv_th5;
  unsigned long uv_th6;
  unsigned long uv_th7;
  unsigned long uv_block_low_th;
  unsigned long uv_block_high_th;
  unsigned long uv_block_core;
} ipr_CNR_sensitivity_t;

#ifdef IPR_ENABLE_CCNR_FUNC
typedef struct {
  unsigned long I_CCNRVT;
  unsigned long I_CCNRHT;
  unsigned long I_CCNRYMT;
  unsigned long I_CCNRCMT1;
  unsigned long I_CCNRCMT2;
} ipr_CCNR_sensitivity_t;

#endif 
typedef struct {
  unsigned long h_start;
  unsigned long v_start;
  unsigned long h_gain;
  unsigned long v_gain;
  unsigned long h_remove_th;
  unsigned long v_remove_th;
} ipr_BNR_strength_t;

typedef struct {
  unsigned long low_th;
  unsigned long high_th;
} ipr_BNR_sensitivity_t;

typedef struct {
  unsigned long  gain;
} ipr_MOSNR_strength_t;

typedef struct {
  unsigned long edge_l;
  unsigned long edge_h;
  unsigned long frame_l;
  unsigned long frame_h;
} ipr_edge_frame_sub_t;

typedef struct {
  unsigned long random_edge;
  unsigned long total_edge;
  unsigned long still;
  unsigned long random_noise;
  unsigned long motion;
} ipr_edge_frame_sub_det_t;

typedef enum {
  IPR_L_CMTX_601 = IPR_L_CMETRY_SD,
  IPR_L_CMTX_709 = IPR_L_CMETRY_HD,
} ipr_color_mtx_t;

typedef struct{
  unsigned char mvip_mix_gain;
  unsigned char mvip_error_th;
  unsigned char mix_rate_2f0f_1f;
  unsigned char match_th_2f0f;
  unsigned char match_th_1f;
}ipr_mvip_param_t;

typedef struct {
  unsigned long md_mode;
  unsigned long diagonal_step;
  unsigned long diagonal_updnth;
  ipr_depth_t ip_bit_depth;
  ipr_onoff_t ymd_mode;
  ipr_onoff_t cmd_mode;
  unsigned char temporal;
  unsigned char delay;
  ipr_onoff_t crmfil;
  ipr_mvip_param_t mvip_param;
} ipr_ipmode_param_t;

typedef struct {
  unsigned long yg;
  unsigned long ub;
  unsigned long vr;
} ipr_color_item_t;

typedef struct {
	enum {
		IPR_L_ASYNC_MSG,
		IPR_L_ERR_MSG,
		IPR_L_SIGINFO_MSG,
	} msg_type;
	union {
		struct {	
			ipr_ER_t err;
			unsigned long serial_num;
			short dev_id;
		} async_msg;
		struct {
			ipr_ERRMSG_t	err;
		} err_rc;
		struct {
			ipr_siginfo_type_t type;
		} siginfo_rc;
	};
} ipr_msg_t;


typedef struct {
    int cmd;
    int (*handler)(int,unsigned int,void *);
} ipr_command_t;

struct iprinit_arg_t {
    int error;
};

struct iprterm_arg_t {
    int error;
};

struct ipropen_arg_t {
	int error;
	short dev_id;
};

struct iprclose_arg_t {
	int error;
	short dev_id;
};

struct iprsetoutputformat_arg_t {
	int error;
	short dev_id; 
	ipr_output_format_t format;
	unsigned long serial_num;
};

struct iprgetoutputformat_arg_t {
	int error;
	short dev_id; 
	ipr_output_format_t format;
};

struct iprsetinputformat_arg_t {
	int error;
	short dev_id; 
	ipr_input_format_t main;
	ipr_input_format_t sub; 
	unsigned long serial_num;
};

struct iprgetinputformat_arg_t {
	int error;
	short  dev_id; 
	ipr_input_format_t main;
	ipr_input_format_t sub;
};

struct iprsettridparam_arg_t {
	int error;
	short  dev_id; 
	ipr_trid_param_t param; 
	unsigned long serial_num;
};

struct iprgettridparam_arg_t {
	int error;
	short  dev_id; 
	ipr_trid_param_t param;
};

struct iprsetlayout_arg_t {
	int error;
	short dev_id; 
	ipr_main_sub_t display;
	ipr_layout_t layout; 
	unsigned long serial_num;
};

struct iprgetlayout_arg_t {
	int error;
	short dev_id; 
	ipr_main_sub_t sys; 
	ipr_layout_t layout;
};

struct iprsetjustparam_arg_t {
	int error;
	short  dev_id; 
	ipr_main_sub_t sys; 
	ipr_just_param_t param; 
	unsigned long serial_num;
};

struct iprgetjustparam_arg_t {
	int error;
	short  dev_id; 
	ipr_main_sub_t sys; 
	ipr_just_param_t param;
};

struct iprgetjuststatus_arg_t {
	int error;
	short  dev_id; 
	ipr_main_sub_t sys;
	ipr_just_status_t info;
};

struct iprsetoverscan_arg_t {
	int error;
	short dev_id; 
	ipr_main_sub_t display;
	ipr_OVS_param_t param;
	unsigned long serial_num;
};

struct iprgetoverscan_arg_t {
	int error;
	short dev_id; 
	ipr_main_sub_t  display; 
	ipr_OVS_param_t param;
};

struct iprrefresh_arg_t {
	int error;
	short  dev_id;
};

struct iprsetsigchgmsg_arg_t {
	int error;
	ipr_port_t  port; 
	ipr_siginfo_condition_t condition;
	unsigned long all_width_thresh_array[IPR_L_MAX_TH_NUM];
	unsigned long all_line_thresh_array[IPR_L_MAX_TH_NUM];
	unsigned long vfreq_thresh_array[IPR_L_MAX_TH_NUM];
	unsigned long hfreq_thresh_array[IPR_L_MAX_TH_NUM];
};

struct iprgetsiginfo_arg_t {
	int error;
	ipr_port_t  port; 
	ipr_siginfo_t info;
};

struct iprsetpause_arg_t {
	int error;
	short dev_id; 
	ipr_main_sub_t sys;
	ipr_onoff_t  pause; 
	unsigned long serial_num;
};

struct iprgetpause_arg_t {
	int error;
	short dev_id;
	ipr_main_sub_t sys;
	ipr_onoff_t pause;
};

struct iprsetdynamicnr_arg_t {
	int error;
	short dev_id; 
	ipr_main_sub_t sys;
	ipr_onoff_t  sw; 
	unsigned long serial_num;
};

struct iprgetdynamicnr_arg_t {
	int error;
	short dev_id;
	ipr_main_sub_t sys;
	ipr_onoff_t sw;
};

struct iprsetynr_arg_t {
	int error;
	short dev_id; 
	ipr_main_sub_t sys;
	ipr_YNR_strength_t strength; 
	ipr_YNR_sensitivity_t sensitivity;
	unsigned long serial_num;
};

struct iprsetcnr_arg_t {
	int error;
	short dev_id; 
	ipr_main_sub_t sys;
	ipr_CNR_strength_t strength; 
	ipr_CNR_sensitivity_t sensitivity;
	unsigned long serial_num;
};

struct iprgetynr_arg_t {
	int error;
	short dev_id; 
	ipr_main_sub_t sys;
	ipr_YNR_strength_t strength; 
	ipr_YNR_sensitivity_t sensitivity;
};

struct iprgetcnr_arg_t {
	int error;
	short dev_id; 
	ipr_main_sub_t sys;
	ipr_CNR_strength_t strength; 
	ipr_CNR_sensitivity_t sensitivity;
};

struct iprsetbnr_arg_t {
	int error;
	short dev_id; 
	ipr_main_sub_t sys;
	ipr_BNR_strength_t strength;
	unsigned long serial_num;
};

struct iprgetbnr_arg_t {
	int error;
	short dev_id; 
	ipr_main_sub_t sys;
	ipr_BNR_strength_t strength;
};

struct iprsetmosnr_arg_t {
	int error;
	short dev_id; 
	ipr_main_sub_t sys;
	ipr_MOSNR_strength_t strength;
	unsigned long serial_num;
};

struct iprgetmosnr_arg_t {
	int error;
	short dev_id; 
	ipr_main_sub_t sys;
	ipr_MOSNR_strength_t strength;
};

struct iprsetedgeframesub_arg_t {
	int error;
	short dev_id; 
	ipr_main_sub_t sys;
	ipr_edge_frame_sub_t param;
	unsigned long serial_num;
};

struct iprgetedgeframesub_arg_t {
	int error;
	short dev_id; 
	ipr_main_sub_t sys;
	ipr_edge_frame_sub_t param;
};

struct iprgetedgeframesubdet_arg_t {
	int error;
	short dev_id; 
	ipr_main_sub_t sys;
	ipr_edge_frame_sub_det_t param;
};

struct iprsetipmode_arg_t {
	int error;
	short dev_id; 
	ipr_main_sub_t sys;
	ipr_ipmode_param_t ipmode_param;
	unsigned long serial_num;
};

struct iprgetipmode_arg_t {
	int error;
	short  dev_id; 
	ipr_main_sub_t  sys;
	ipr_ipmode_param_t ipmode_param;
};

struct iprsetcolormatrix_arg_t {
	int error;
	short dev_id;
	ipr_port_t port;
	ipr_color_mtx_t matrix;
	unsigned long serial_num;
};

struct iprgetcolormatrix_arg_t {
	int error;
	short dev_id;
	ipr_port_t port;
	ipr_color_mtx_t matrix;
};

struct iprsetcmetryconvert_arg_t {
	int error;
	short dev_id;
	ipr_main_sub_t sys;
	ipr_cmetry_t conv;
	unsigned long serial_num;
};

struct iprgetcmetryconvert_arg_t {
	int error;
	short dev_id;
	ipr_main_sub_t sys;
	ipr_cmetry_t conv;
};


struct iprsetbackground_arg_t {
	int error;
	short dev_id; 
	ipr_color_t color_type;
	ipr_color_item_t item; 
	unsigned long serial_num;
};

struct iprgetbackground_arg_t {
	int error;
	short dev_id; 
	ipr_color_t color_type;
	ipr_color_item_t item; 
};

struct iprsetmaaffilter_arg_t {
	int error;
	short dev_id; 
	ipr_onoff_t sw;
	ipr_filter_t factor;
	unsigned long serial_num;
};

struct iprgetmaaffilter_arg_t {
	int error;
	short dev_id; 
	ipr_onoff_t sw;
	ipr_filter_t factor;
};

struct iprsetsaaffilter_arg_t {
	int error;
	short  dev_id; 
	ipr_onoff_t sw;
	ipr_filter_t factor;
	unsigned long serial_num;
};

struct iprgetsaaffilter_arg_t {
	int error;
	short dev_id; 
	ipr_onoff_t sw;
	ipr_filter_t factor;
};

struct iprsetselfwideparam_arg_t {
	int error;
	short dev_id; 
	ipr_onoff_t onoff;
	ipr_detection_window_t window_param;
	ipr_class_thresh_t class_param;
	ipr_histgram_thresh_t histgram_param;
	ipr_selfwide_err_thresh_t error_param;
	unsigned long serial_num;
};

struct iprsetyuvlevel_arg_t {
	int error;
	short dev_id;
	ipr_main_sub_t sys;
	ipr_YUV_level_t level;
	unsigned long serial_num;
};

struct iprgetyuvlevel_arg_t {
	int error;
	short dev_id; 
	ipr_main_sub_t sys;
	ipr_YUV_level_t level;
};

struct iprselectactsignal_arg_t {
	int error;
	short dev_id; 
	ipr_port_t port;
	ipr_onoff_t onoff;
	unsigned long serial_num;
};

struct iprgetactsignal_arg_t {
	int error;
	short dev_id; 
	ipr_port_t port;
	ipr_onoff_t onoff;
};

struct iprsetmute_arg_t {
	int error;
	short dev_id;
	ipr_main_sub_t sys; 
	ipr_onoff_t onoff;
	unsigned long serial_num;
};

struct iprgetmute_arg_t {
	int error;
	short dev_id; 
	ipr_main_sub_t sys;
};

struct iprgetpulldowndet_arg_t{
	int error;
	short dev_id; 
	ipr_main_sub_t sys;
	ipr_pulldown_mode_t result;
	ipr_pulldown_mode_t telop_result;
	ipr_pulldown_mode_t integrated_result;
};

struct iprset422fix_arg_t{
	int error;
	short dev_id; 
	ipr_onoff_t fix;
	unsigned long serial_num;
};

struct iprget422fix_arg_t{
	int error;
	short dev_id; 
	ipr_onoff_t fix;
	unsigned long serial_num;
};


typedef struct {
  IPR_FIX16 hstart_ratio;
  IPR_FIX16 vstart_ratio;
  IPR_FIX16 hlen_ratio;
  IPR_FIX16 vlen_ratio;
} ipr_pulldown_det_win_t;

typedef struct {
  IPR_FIX16 win1_hstart_ratio;  
  IPR_FIX16 win1_vstart_ratio;
  IPR_FIX16 win1_hlen_ratio;
  IPR_FIX16 win1_vlen_ratio;
  IPR_FIX16 win2_hstart_ratio;
  IPR_FIX16 win2_vstart_ratio;
  IPR_FIX16 win2_hlen_ratio;
  IPR_FIX16 win2_vlen_ratio;
} ipr_telop_det_win_t;

typedef enum {
  IPR_L_PULLDOWN_OLD_CIRCUIT,
  IPR_L_PULLDOWN_MC_CIRCUIT,
} ipr_pulldown_circuit_t;

typedef struct{
  ipr_pulldown_circuit_t circuit;
  unsigned short cadence_sw;
  ipr_pulldown_det_win_t pulldown_det_win;
  ipr_telop_det_win_t telop_det_win;
  unsigned char old_2_3_pix_th;
  IPR_FIX16 old_2_3_wid_th;
  unsigned char old_2_3_time_th;
  unsigned char old_2_2_time_th;
  IPR_FIX16 mc_field_th;
  IPR_FIX16 mc_frame_th;
  IPR_FIX16 mc_video_th;
  unsigned char mc_2_2_time_th;
  unsigned char mc_2_3_time_th;
  unsigned char mc_2332_time_th;
  unsigned char mc_2224_time_th;
  unsigned char mc_55_time_th;
  unsigned char mc_64_time_th;
  unsigned char mc_87_time_th;
  unsigned long telop_pix_th;
  IPR_FIX16 telop_win1_th;
  IPR_FIX16 telop_win2_th;
} ipr_pulldown_t;

typedef struct{
  unsigned long thresh_low;
  unsigned long thresh_high;
  unsigned long width;
  unsigned long filter_width;
} ipr_impulsenr_t;

typedef struct{
  ipr_onoff_t   adaptivefilter;
  ipr_onoff_t   deringing;
  unsigned char positive_gain;
  unsigned char negative_gain;
} ipr_adaptivefilter_t;

struct iprsetpulldownmode_arg_t{
  int error;
  short dev_id;
  ipr_main_sub_t sys;
  ipr_pulldown_t pull_down;
  unsigned long serial_num;
};

struct iprgetpulldownmode_arg_t{
  int error;
  short dev_id;
  ipr_main_sub_t sys;
  ipr_pulldown_t pull_down;
};

struct iprsetsidepanel_arg_t{
	int error;
	short dev_id;
  ipr_main_sub_t sys;
  ipr_sidepanel_t sidepanel;
	unsigned long serial_num;
};

struct iprgetsidepanel_arg_t{
	int error;
	short dev_id;
  ipr_main_sub_t sys;
  ipr_sidepanel_t sidepanel;
};

struct iprgetsidepaneldet_arg_t{
	int error;
	short dev_id;
  ipr_main_sub_t sys;
  ipr_get_spdet_t get_spdet;
};

struct iprsetmemtakeover_arg_t {
  int error;
  short dev_id; 
	ipr_port_t port;
  unsigned long serial_num;
};

struct iprgetmemtakeover_arg_t {
  int error;
  short dev_id; 
	ipr_port_t port;
};

struct iprgetpixel_arg_t {
	int error;
	short dev_id; 
	ipr_pix_place_t module;
	unsigned short x; 
	unsigned short y; 
	ipr_pix_t pinfo;
};


struct iprctldmaaccess_arg_t{
	int error;
	short dev_id;
	ipr_onoff_t sw;
	ipr_dma_port_t dma_port;
};

struct iprdbgdumpstatus_arg_t{
	int error; 
	int buf_shmid;
	unsigned long buf_size;
};

struct iprmeasurepcsignal_arg_t{
	int error;
	short dev_id;
	ipr_pc_format_t pmeasure;
};

struct iprasynccallback_arg_t{
	ipr_msg_t msg;
};

struct iprselfwidecallback_arg_t{
	ipr_selfwide_param_t param;
};

struct iprsetimpulsenr_arg_t {
	int error;
	short  dev_id; 
	ipr_main_sub_t sys;
	ipr_impulsenr_t inr_info; 
	unsigned long serial_num;
};

struct iprgetimpulsenr_arg_t {
	int error;
	short  dev_id; 
	ipr_main_sub_t sys;
	ipr_impulsenr_t inr_info;
};

struct iprsetadaptivefilter_arg_t {
	int error;
	short  dev_id; 
	ipr_main_sub_t sys;
	ipr_adaptivefilter_t adfil_info; 
	unsigned long serial_num;
};

struct iprgetadaptivefilter_arg_t {
	int error;
	short  dev_id; 
	ipr_main_sub_t sys;
	ipr_adaptivefilter_t adfil_info;
};

struct iprsetmaxhlen_arg_t {
	int error;
	short dev_id;
	unsigned long main_hlen;
	unsigned long sub_hlen;
	unsigned long serial_num;
};

struct iprgetmaxhlen_arg_t {
	int error;
	short dev_id; 
	unsigned long main_hlen;
	unsigned long sub_hlen;
};




struct iprgetdynamicnrcurrentlevel_arg_t {
	int error;
	short dev_id; 
    ipr_main_sub_t sys;
	ipr_DNR_level_t param;
};


struct iprrefmpl_arg_t {
	int error;
	int size; 
};

struct iprsetvfilter_arg_t {
	int error;
	short dev_id;
	ipr_main_sub_t sys;
	unsigned long strength;
	unsigned long serial_num;
};

struct iprgetvfilter_arg_t {
	int error;
	short dev_id;
	ipr_main_sub_t sys;
	unsigned long strength;
};

#endif	
